
//// change these to suit the application ////

#define SDCARD_SPI        2
#define SDCARD_DMA		  1
#define SDCARD_DIN_RP     12
#define SDCARD_DIN_PORT   B
#define SDCARD_DIN_PIN    12
#define SDCARD_CLK_RP     13
#define SDCARD_CLK_PORT   B
#define SDCARD_CLK_PIN    13
#define SDCARD_DOUT_RP    14
#define SDCARD_DOUT_PORT  B
#define SDCARD_DOUT_PIN   14

/////////////////////////////////////////////

#include "GenericTypeDefs.h"
#include "spi.h"
#include "p33Fxxxx.h"
#include <string.h>

/* 
	SPI Module Firmware
	by Mauro Grassi, 2009-2010.
*/

#define _SPISTATname(spi) SPI##spi##STAT
#define SPISTATname(spi)  _SPISTATname(spi)
#define _SPISTATbits(spi) SPI##spi##STATbits
#define SPISTATbits(spi)  _SPISTATbits(spi)
#define _SPICON1name(spi) SPI##spi##CON1
#define SPICON1name(spi)  _SPICON1name(spi)
#define _SPICON1bits(spi) SPI##spi##CON1bits
#define SPICON1bits(spi)  _SPICON1bits(spi)
#define _SPICON2name(spi) SPI##spi##CON2
#define SPICON2name(spi)  _SPICON2name(spi)
#define _SPIBUFname(spi)  SPI##spi##BUF
#define SPIBUFname(spi)   _SPIBUFname(spi)
#define _SPIIEname(spi)   _SPI##spi##IE
#define SPIIEname(spi)    _SPIIEname(spi)
#define _SPIIFname(spi)   _SPI##spi##IF
#define SPIIFname(spi)    _SPIIFname(spi)
#define _RPORbits(a,b)    RPOR##a##bits.RP##b##R
#define RPORbits(a,b)     _RPORbits(a,b)
#define _TRISbits(a,b)    TRIS##a##bits.TRIS##a##b
#define TRISbits(a,b)     _TRISbits(a,b)
#define _LATbits(a,b)     LAT##a##bits.LAT##a##b
#define LATbits(a,b)      _LATbits(a,b)
#define _DMACONname(dma)  DMA##dma##CON
#define DMACONname(dma)   _DMACONname(dma)
#define _DMACONbits(dma)  DMA##dma##CONbits
#define DMACONbits(dma)   _DMACONbits(dma)
#define _DMASTAname(dma)  DMA##dma##STA
#define DMASTAname(dma)   _DMASTAname(dma)
#define _DMAPADname(dma)  DMA##dma##PAD
#define DMAPADname(dma)   _DMAPADname(dma)
#define _DMACNTname(dma)  DMA##dma##CNT
#define DMACNTname(dma)   _DMACNTname(dma)
#define _DMAREQname(dma)  DMA##dma##REQ
#define DMAREQname(dma)   _DMAREQname(dma)

#define SLOW_SPI_DELAY 64

#ifdef USE_DMA
unsigned char SPIRxBuffer[512] __attribute__((space(dma)));
#endif

void InitSPI(int speed)
{
	/* Initialise the SPI System */
	SDCS=1;
	SDCS_TRIS=0;
	SPISTATname(SDCARD_SPI)=0;
	SPICON1name(SDCARD_SPI)=0;
	SPICON2name(SDCARD_SPI)=0;

	// set up SPI pins
	TRISbits(SDCARD_DOUT_PORT, SDCARD_DOUT_PIN) = 0;
	LATbits(SDCARD_DOUT_PORT, SDCARD_DOUT_PIN) = 1;
	TRISbits(SDCARD_CLK_PORT, SDCARD_CLK_PIN) = 0;
	TRISbits(SDCARD_DIN_PORT, SDCARD_DIN_PIN) = 1;
	
	/* Speed Selection
		SPIxCON1<4:2>= 	Secondary Prescaler (Master Mode)
						111b	1:1
						110b	2:1
						...	
						000b	8:1
		SPIxCON1<1:0>=	Primary Prescaler (Master Mode)
						11b		1:1
						10b		4:1
						01b		16:1
						00b		64:1

		Note: do not set both to 1:1
	*/

	SPICON1name(SDCARD_SPI)=(0x1F & speed);
	SPICON1bits(SDCARD_SPI).MODE16=0;		/*  8 bit mode */
	SPICON1bits(SDCARD_SPI).SMP=0;			/* input data sampling */
	SPICON1bits(SDCARD_SPI).CKP=0;			/* clock Polarity 0: idle low, active high 1: idle high, active low */
	SPICON1bits(SDCARD_SPI).CKE=1;			/* clock edge selection */
	SPICON1bits(SDCARD_SPI).MSTEN=1;		/* enable Master Mode */
	SPISTATbits(SDCARD_SPI).SPIROV=0;
	SPIIFname(SDCARD_SPI)=0;
	SPIIEname(SDCARD_SPI)=0;
	SPISTATbits(SDCARD_SPI).SPIEN=1;

#ifdef USE_DMA
	DMACONname(SDCARD_DMA) = 0x4801;
	DMASTAname(SDCARD_DMA) = __builtin_dmaoffset(SPIRxBuffer);
	DMAPADname(SDCARD_DMA) = (volatile unsigned int) &SPIBUFname(SDCARD_SPI);
	DMACNTname(SDCARD_DMA) = 511;//255;//511;
	DMAREQname(SDCARD_DMA) = 10;//0x0021;
#endif
}

unsigned int WriteSPI(unsigned int x)
{
	SDCS=0;
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SPIBUFname(SDCARD_SPI)=x;
	while(SPISTATbits(SDCARD_SPI).SPITBF)Nop();
	while(SPISTATbits(SDCARD_SPI).SPIRBF==0)Nop();
	x=SPIBUFname(SDCARD_SPI);
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SDCS=1;
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	return x;
}

#ifdef USE_DMA
unsigned char* BulkReadSPI() {
/*
	unsigned char i = 0;
	SDCS = 0;

//	SPISTATbits(SDCARD_SPI).SPIEN=0;
//	SPICON1bits(SDCARD_SPI).DISSDO=1;
//	SPICON1bits(SDCARD_SPI).MODE16=1;
//	SPISTATbits(SDCARD_SPI).SPIEN=1;
	DMACONbits(SDCARD_DMA).CHEN=1;
    do {
      SPIBUFname(SDCARD_SPI) = 0xFF;
	  while(SPISTATbits(SDCARD_SPI).SPITBF)Nop();
	  while(SPISTATbits(SDCARD_SPI).SPIRBF==0)Nop();
    } while( ++i );
//	SPIBUFname(SDCARD_SPI) = 0x00;
//	while( DMACONbits(SDCARD_DMA).CHEN )
//		Nop();
//	SPISTATbits(SDCARD_SPI).SPIEN=0;
//	SPICON1bits(SDCARD_SPI).DISSDO=0;
//	SPICON1bits(SDCARD_SPI).MODE16=0;
//	SPISTATbits(SDCARD_SPI).SPIEN=1;
	SDCS = 1;
	return (unsigned char*)SPIRxBuffer;
*/
}

void BulkReadSPIInto(unsigned char* buf) {
	SDCS = 0;

	SPISTATbits(SDCARD_SPI).SPIEN=0;
	SPICON1bits(SDCARD_SPI).DISSDO=1;
	SPICON1bits(SDCARD_SPI).MODE16=1;		/*  16 bit mode */
	SPISTATbits(SDCARD_SPI).SPIEN=1;
	DMASTAname(SDCARD_DMA) = (unsigned short)buf;
	DMACONbits(SDCARD_DMA).CHEN=1;
	SPIBUFname(SDCARD_SPI) = 0x00;
	while( DMACONbits(SDCARD_DMA).CHEN )
		Nop();
	DMASTAname(SDCARD_DMA) = __builtin_dmaoffset(SPIRxBuffer);
	SPISTATbits(SDCARD_SPI).SPIEN=0;
	SPICON1bits(SDCARD_SPI).DISSDO=0;
	SPICON1bits(SDCARD_SPI).MODE16=0;		/*  8 bit mode */
	SPISTATbits(SDCARD_SPI).SPIEN=1;
	SDCS = 1;
}
#endif

unsigned int WriteSPIWithoutSS(unsigned int x)
{
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SPIBUFname(SDCARD_SPI)=x;
	while(SPISTATbits(SDCARD_SPI).SPITBF)Nop();
	while(SPISTATbits(SDCARD_SPI).SPIRBF==0)Nop();
	x=SPIBUFname(SDCARD_SPI);
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	return x;
}

void SPI_Add_Extra_Clocks(unsigned char num) {
	LATbits(SDCARD_CLK_PORT, SDCARD_CLK_PIN) = 0;
	SPISTATbits(SDCARD_SPI).SPIEN=0;
	while( num-- ) {
		LATbits(SDCARD_CLK_PORT, SDCARD_CLK_PIN) = 1;
		Nop();
		LATbits(SDCARD_CLK_PORT, SDCARD_CLK_PIN) = 0;
		Nop();
	}
	SPISTATbits(SDCARD_SPI).SPIEN=1;
}
